/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.extras;

import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class NonNullValueModel
extends AbstractValueModel {
    private final ValueModel subject;
    private final Object defaultValue;

    public NonNullValueModel(ValueModel subject, Object defaultValue) {
        this.subject = subject;
        this.defaultValue = Preconditions.checkNotNull(defaultValue, "The default value must not be null.");
        subject.addValueChangeListener(new SubjectValueChangeHandler());
    }

    @Override
    public Object getValue() {
        Object subjectValue = this.subject.getValue();
        return subjectValue != null ? subjectValue : this.defaultValue;
    }

    @Override
    public void setValue(Object newValue) {
        this.subject.setValue(newValue);
    }

    private final class SubjectValueChangeHandler
    implements PropertyChangeListener {
        private SubjectValueChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NonNullValueModel.this.fireValueChange(evt.getOldValue(), evt.getNewValue(), true);
        }
    }
}

